#version 330

layout(points) in;
layout(triangle_strip) out;
layout(max_vertices = 4) out;

uniform float uScale;
uniform mat4 uVP;
uniform vec3 uCameraPosition;

out vec2 gsTextureCoord;

void main()
{
	vec3 position = gl_in[0].gl_Position.xyz;
	vec3 posToCamera = normalize(uCameraPosition - position);
	vec3 up = vec3(0.0, 1.0, 0.0);
	vec3 right = cross(posToCamera, up);
	
	position -= (right*uScale * 0.5);
	gl_Position = uVP * vec4(position, 1.0);
	gsTextureCoord = vec2(0.0, 1.0);
	EmitVertex();
	
	position += right*uScale;
	gl_Position = uVP * vec4(position, 1.0);
	gsTextureCoord = vec2(1.0, 1.0);
	EmitVertex();

	position.y += uScale;
	position -= right*uScale;
	gl_Position = uVP * vec4(position, 1.0);
	gsTextureCoord = vec2(0.0, 0.0);
	EmitVertex();

	position += right*uScale;
	gl_Position = uVP * vec4(position, 1.0);
	gsTextureCoord = vec2(1.0, 0.0);
	EmitVertex();
	
	EndPrimitive();
}

