#version 400

const int MAX_SPOT_LIGHTS = 3;

layout (location = 0) in vec3 iPosition;
layout (location = 1) in vec3 iColor;
layout (location = 2) in vec2 iTextureCoord;
layout (location = 3) in vec3 iNormal;
layout (location = 4) in vec3 iTangent;

uniform mat4 uWVP;
uniform mat4 uW;
uniform mat4 uLightWVP[MAX_SPOT_LIGHTS];

out vec4 vsColor;
out vec2 vsTextureCoord;
out vec3 vsNormal;
out vec3 vsTangent;
out vec3 vsWorldPosition;
out vec4 vsLightPositions[MAX_SPOT_LIGHTS];

void main()
{
	gl_Position = uWVP * vec4(iPosition, 1.0);
	vsColor = vec4(iColor,1);
	vsTextureCoord = iTextureCoord;
	
	vsNormal = (uW * vec4(iNormal, 0.0)).xyz;
	vsTangent = (uW * vec4(iTangent, 0.0)).xyz;
	
	vsWorldPosition = (uW * vec4(iPosition, 1.0)).xyz;

	for(int i = 0; i < MAX_SPOT_LIGHTS; ++i)
	{
		vsLightPositions[i] = uLightWVP[i] * vec4(iPosition, 1.0);
	}
		
}
