#version 330

layout (location = 0) in vec3 iPosition;
layout (location = 1) in vec3 iColor;
layout (location = 2) in vec2 iTextureCoord;
layout (location = 3) in vec3 iNormal;

uniform mat4 uWVP;
uniform mat4 uW;

out vec4 vsColor;
out vec2 vsTextureCoord;
out vec3 vsNormal;
out vec3 vsWorldPosition;

void main()
{
	gl_Position = uWVP * vec4(iPosition, 1.0);
	vsColor = vec4(iColor,1); 
	vsTextureCoord = iTextureCoord;
	vsNormal = (uW * vec4(iNormal, 0.0)).xyz;
	vsWorldPosition = (uW * vec4(iPosition, 1.0)).xyz;
}
